@ECHO OFF
SETLOCAL ENABLEDELAYEDEXPANSION
SET DEBUGLOG="%Temp%\debug.log"
ECHO.>%DEBUGLOG%
SET FNDSTR1=" [0-9][  0-9]   [^Aa-Zz][^Aa-Zz]  ...........* *NTFS *.......... *[12]00 M.  "
SET FNDSTR2=" [0-9][  0-9]   [^Aa-Zz][^Aa-Zz]  "
SET SLMGR=cscript //NOLOGO "%SYSTEMROOT%\System32\slmgr.vbs"
ECHO %DATE% - %TIME% >>%DEBUGLOG%
CHCP >>%DEBUGLOG%

CALL :PRODUCT_VER_CHECK

:START
CALL :CLEANUP
IF EXIST "%TEMP%\UNMOUNT" DISKPART /S "%TEMP%\UNMOUNT" >>%DEBUGLOG%
REG QUERY "HKLM\Software\Microsoft\Windows NT\CurrentVersion" /v "BuildLabEx" >>%DEBUGLOG%
REG QUERY "HKLM\Software\Microsoft\Windows NT\CurrentVersion" /v "ProductName" >>%DEBUGLOG%

:FILECHK
IF NOT EXIST "%~dp0bootinst_w7ldr.exe" ECHO ERROR: bootinst.exe is missing >>%DEBUGLOG% & GOTO :ERROR
IF NOT EXIST "%~dp0cert.xrm-ms" ECHO ERROR: cert.xrm-ms is missing >>%DEBUGLOG% & GOTO :ERROR
IF NOT EXIST "%~dp0md5.exe" ECHO ERROR: md5.exe is missing >>%DEBUGLOG% & GOTO :ERROR
IF NOT EXIST "%~dp0slic" ECHO ERROR: slic is missing >>%DEBUGLOG% & GOTO :ERROR
IF NOT EXIST "%~dp0w7ldr1" ECHO ERROR: w7ldr1 is missing >>%DEBUGLOG% & GOTO :ERROR
IF NOT EXIST "%~dp0w7ldr2" ECHO ERROR: w7ldr2 is missing >>%DEBUGLOG% & GOTO :ERROR

"%~dp0md5.exe" /cF9D519ADF07380DA7243191E6A7831F7 "%~dp0bootinst_w7ldr.exe"
IF ERRORLEVEL 1 ECHO ERROR: bootinst_w7ldr.exe md5 failed >>%DEBUGLOG% & GOTO :ERROR

"%~dp0md5.exe" /c18B1E45BF56F40C3C4BBE65831178216 "%~dp0cert.xrm-ms"
IF ERRORLEVEL 1 ECHO ERROR: cert.xrm-ms md5 failed >>%DEBUGLOG% & GOTO :ERROR

"%~dp0md5.exe" /c7EE5638B3D64247202A366AD3CB0795C "%~dp0slic"
IF ERRORLEVEL 1 ECHO ERROR: slic md5 failed >>%DEBUGLOG% & GOTO :ERROR

"%~dp0md5.exe" /c1AAEE165E39BB78BEEF5F9FA2D3922F8 "%~dp0w7ldr1"
IF ERRORLEVEL 1 ECHO ERROR: w7ldr1 md5 failed >>%DEBUGLOG% & GOTO :ERROR

"%~dp0md5.exe" /c3BB8553F8E230F58F116157C4318E2E0 "%~dp0w7ldr2"
IF ERRORLEVEL 1 ECHO ERROR: w7ldr2 md5 failed >>%DEBUGLOG% & GOTO :ERROR

"%~dp0md5.exe" /c519E1BB29B7165646AF08D83B9512774 "%~dp0md5.exe"
IF ERRORLEVEL 1 ECHO ERROR: md5.exe md5 failed >>%DEBUGLOG% & GOTO :ERROR

ECHO all ok >>%DEBUGLOG%


:STARTSVC
SC QUERY SPPSVC | FINDSTR /I "RUNNING" >>%DEBUGLOG%
IF ERRORLEVEL 1 NET START SPPSVC >>%DEBUGLOG%
SC CONFIG SPPSVC START= Auto >>%DEBUGLOG%


:FINDPARTITION
TASKLIST | FIND "vmware.exe">nul
IF NOT ERRORLEVEL 1 (
   ECHO.
   ECHO ERROR: vmware is running.
   GOTO :ERROR
)>>%DEBUGLOG%
ECHO LIST VOL | DISKPART >>%DEBUGLOG%
IF EXIST "%USERPROFILE%\Desktop\work_dammit" (
   ECHO. >>%DEBUGLOG%
   ECHO. >>%DEBUGLOG%
   ECHO work dammit set >>%DEBUGLOG%
   ECHO using %FNDSTR2% >>%DEBUGLOG%
   SET STR=%FNDSTR2%
) ELSE (
   SET STR=%FNDSTR1%
   ECHO. >>%DEBUGLOG%
   ECHO. >>%DEBUGLOG%
   ECHO using %FNDSTR1% >>%DEBUGLOG%
)
ECHO.>>%DEBUGLOG%
For /F "tokens=2" %%I IN ('ECHO LIST VOL ^| DISKPART ^| FINDSTR /R /C:%STR%') DO CALL :PARSE %%I
IF '%FREEDRIVELETTER%'=='0' ECHO ERROR: could not assign drive letter.>>%DEBUGLOG% & GOTO :ERROR
GOTO :DO_IT


:PARSE
SET FREEDRIVELETTER=0
FOR %%p IN (C D E F G H I J K L M N O P Q R S T U V W X Y Z B) DO (
   ECHO LIST VOL | DISKPART | FINDSTR /C:"     %%p   " >>%DEBUGLOG%
   IF ERRORLEVEL 1 NET USE | FINDSTR /C:" %%p:  " >>%DEBUGLOG%
IF EXIST "%USERPROFILE%\Desktop\work_dammit" (
   IF ERRORLEVEL 1 (
	ECHO SELECT VOLUME %1 > "%TEMP%\MOUNT_CHK"
	ECHO ASSIGN LETTER=%%p >> "%TEMP%\MOUNT_CHK"
	ECHO SELECT VOLUME %1 > "%TEMP%\UNMOUNT_CHK"
	ECHO REMOVE >> "%TEMP%\UNMOUNT_CHK"
	IF EXIST "%TEMP%\MOUNT_CHK" DISKPART /S "%TEMP%\MOUNT_CHK" >nul
	IF ERRORLEVEL 1 (ECHO ERROR: letter %%p already in use. >>%DEBUGLOG% & GOTO :EOF) ELSE (
	SET FREEDRIVELETTER=%%p)
	IF EXIST "%TEMP%\UNMOUNT_CHK" DISKPART /S "%TEMP%\UNMOUNT_CHK" >nul
	)
      ) ELSE (IF ERRORLEVEL 1 SET FREEDRIVELETTER=%%p)
   )
   ECHO SELECT VOLUME %1 >> "%TEMP%\MOUNT"
   ECHO ASSIGN LETTER=%FREEDRIVELETTER% >> "%TEMP%\MOUNT"
   ECHO SELECT VOLUME %1 >> "%TEMP%\UNMOUNT"
   ECHO REMOVE >> "%TEMP%\UNMOUNT"
   IF EXIST "%TEMP%\MOUNT" DISKPART /S "%TEMP%\MOUNT" >>%DEBUGLOG%
   IF ERRORLEVEL 1 ECHO ERROR: mount %%p failed >>%DEBUGLOG% & GOTO :ERROR
GOTO :EOF


:DO_IT
SET SLMGR_HAS_RUN=0
SET BOOTMGR_FOUND=0
ECHO LIST DISK | DISKPART | FINDSTR /C:"   *   " >>%DEBUGLOG%
IF NOT ERRORLEVEL 1 ECHO ERROR: dynamic disk>>%DEBUGLOG% & GOTO :ERROR
FOR %%A IN (C D E F G H I J K L M N O P Q R S T U V W X Y Z B) DO (
ECHO LIST VOL | DISKPART | FINDSTR /R /C:" %%A .*  0 B  " >>%DEBUGLOG%
IF ERRORLEVEL 1 (
      IF EXIST "%%A:\bootmgr" "%~dp0md5.exe" /cD6AE2D5521DD93AEBC90D411D099FA36 "%%A:\BOOTMGR" >>%DEBUGLOG%
	IF NOT ERRORLEVEL 1 (
          SET /A BOOTMGR_FOUND=!BOOTMGR_FOUND!+1
	    IF NOT EXIST "%%A:\autorun.inf" (
		DIR /A: %%A:\>>%DEBUGLOG%
		IF EXIST "%%A:\w7ldr" ATTRIB "%%A:\w7ldr" -h -s -r >>%DEBUGLOG%
		IF EXIST "%%A:\w7ldr.bak" DEL "%%A:\w7ldr.bak" >>%DEBUGLOG%
		IF EXIST "%%A:\grldr.bak" DEL "%%A:\grldr.bak" >>%DEBUGLOG%
		IF EXIST "%%A:\w7ldr" "%~dp0md5.exe" /cDE0A5EFAEE4988097C4AC50F3D1F9FDB "%%A:\w7ldr" >>%DEBUGLOG%
		IF ERRORLEVEL 1 (
		   DEL "%%A:\w7ldr"
		   COPY /b "%~dp0w7ldr1" + "%~dp0slic" + "%~dp0w7ldr2" "%%A:\w7ldr") >>%DEBUGLOG%
		IF NOT EXIST "%%A:\w7ldr" COPY /b "%~dp0w7ldr1" + "%~dp0slic" + "%~dp0w7ldr2" "%%A:\w7ldr" >>%DEBUGLOG%
		"%~dp0md5.exe" /cDE0A5EFAEE4988097C4AC50F3D1F9FDB "%%A:\w7ldr" >>%DEBUGLOG%
		IF ERRORLEVEL 1 ECHO ERROR: w7ldr md5 check failed & GOTO :ERROR >>%DEBUGLOG%
		IF EXIST "%%A:\w7ldr" ATTRIB "%%A:\w7ldr" +h +s +r >>%DEBUGLOG%
		IF EXIST "%%A:\w7ldr" "%~dp0bootinst_w7ldr.exe" /nt60 %%A: >>%DEBUGLOG%
		DIR /A: %%A:\ >>%DEBUGLOG%
		ECHO. >>%DEBUGLOG%
		IF !SLMGR_HAS_RUN!==0 (
		   %SLMGR% -ipk 342DG-6YJR8-X92GV-V7DCV-P4K27
		   %SLMGR% -ilc "%~dp0cert.xrm-ms" >>%DEBUGLOG%
		   SET SLMGR_HAS_RUN=1
		   ECHO SLMGR_HAS_RUN set to !SLMGR_HAS_RUN! >>%DEBUGLOG%
		   ECHO. >>%DEBUGLOG%
		)
  	    ) ELSE (ECHO. & ECHO ^>^>^>^>autorun.inf found skipping drive %%A:^<^<^<^< & ECHO.)>>%DEBUGLOG%	
	)
   )
)
IF %BOOTMGR_FOUND%==0 (
ECHO ERROR: bootmgr not found >>%DEBUGLOG%
GOTO :ERROR
 )

ECHO. >>%DEBUGLOG%
ECHO BOOTMGR found %BOOTMGR_FOUND% time(s) >>%DEBUGLOG%
IF EXIST "%TEMP%\UNMOUNT" DISKPART /S "%TEMP%\UNMOUNT" >>%DEBUGLOG%
CALL :CLEANUP & GOTO :FINISH


:ERROR
ECHO error:=============================================================================================== >>%DEBUGLOG%
IF EXIST "%TEMP%\UNMOUNT" DISKPART /S "%TEMP%\UNMOUNT" >>%DEBUGLOG%
MOVE /Y %DEBUGLOG% "%USERPROFILE%\Desktop" >nul
ECHO  ERROR: install failed.
ECHO.
ECHO  Press any key to exit.
PAUSE >nul
CALL :CLEANUP & EXIT


:CLEANUP
IF EXIST "%TEMP%\UNMOUNT" DEL /Q "%TEMP%\UNMOUNT"
IF EXIST "%TEMP%\MOUNT" DEL /Q "%TEMP%\MOUNT"
IF EXIST "%TEMP%\UNMOUNT" DEL /Q "%TEMP%\UNMOUNT_CHK"
IF EXIST "%TEMP%\MOUNT" DEL /Q "%TEMP%\MOUNT_CHK"
GOTO :EOF


:PRODUCT_VER_CHECK

   REG QUERY "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion" /v "ProductName" | FINDSTR /C:"Windows 7" >nul
   IF ERRORLEVEL 1 ECHO ERROR: not Windows 7 >>%DEBUGLOG% & ECHO. & GOTO :ERROR

   FOR /F "tokens=3" %%A IN ('REG QUERY "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion" /v "EditionID"') DO SET EditionID=%%A

   ECHO %EditionID% | FINDSTR /I "Starter" >nul
   IF NOT ERRORLEVEL 1 CALL :STARTER_KEY & GOTO :EOF

   ECHO %EditionID% | FINDSTR /I "HomeBasic" >nul
   IF NOT ERRORLEVEL 1 CALL :HOMEBASIC_KEY & GOTO :EOF

   ECHO %EditionID% | FINDSTR /I "HomePremium" >nul
   IF NOT ERRORLEVEL 1 CALL :HOMEPREMIUM_KEY & GOTO :EOF

   ECHO %EditionID% | FINDSTR /I "Professional" >nul
   IF NOT ERRORLEVEL 1 CALL :PROFESSIONAL_KEY & GOTO :EOF

   ECHO %EditionID% | FINDSTR /I "Ultimate" >nul
   IF NOT ERRORLEVEL 1 CALL :ULTIMATE_KEY & GOTO :EOF

   IF ERRORLEVEL 1 ECHO ERROR: OS is unsupported>>%DEBUGLOG% & ECHO. & GOTO :ERROR
GOTO :EOF


:STARTER_KEY
   ECHO ERROR: no keys yet>>%DEBUGLOG% & ECHO. & GOTO :ERROR
   SET MAX_RANDOM=1
   SET /A RANDOM_PID_KEY=%RANDOM% %% %MAX_RANDOM%
   IF '%RANDOM_PID_KEY%'=='0' SET PID_KEY=
   IF '%RANDOM_PID_KEY%'=='1' SET PID_KEY=
   IF '%RANDOM_PID_KEY%'=='2' SET PID_KEY=
   IF '%RANDOM_PID_KEY%'=='3' SET PID_KEY=
   IF '%RANDOM_PID_KEY%'=='4' SET PID_KEY=
GOTO :EOF


:HOMEBASIC_KEY
   ECHO ERROR: no keys yet>>%DEBUGLOG% & ECHO. & GOTO :ERROR
   SET MAX_RANDOM=1
   SET /A RANDOM_PID_KEY=%RANDOM% %% %MAX_RANDOM%
   IF '%RANDOM_PID_KEY%'=='0' SET PID_KEY=
   IF '%RANDOM_PID_KEY%'=='1' SET PID_KEY=
   IF '%RANDOM_PID_KEY%'=='2' SET PID_KEY=
   IF '%RANDOM_PID_KEY%'=='3' SET PID_KEY=
   IF '%RANDOM_PID_KEY%'=='4' SET PID_KEY=
GOTO :EOF


:HOMEPREMIUM_KEY
   ECHO ERROR: no keys yet>>%DEBUGLOG% & ECHO. & GOTO :ERROR
   SET MAX_RANDOM=1
   SET /A RANDOM_PID_KEY=%RANDOM% %% %MAX_RANDOM%
   IF '%RANDOM_PID_KEY%'=='0' SET PID_KEY=
   IF '%RANDOM_PID_KEY%'=='1' SET PID_KEY=
   IF '%RANDOM_PID_KEY%'=='2' SET PID_KEY=
   IF '%RANDOM_PID_KEY%'=='3' SET PID_KEY=
   IF '%RANDOM_PID_KEY%'=='4' SET PID_KEY=
GOTO :EOF


:PROFESSIONAL_KEY
   SET MAX_RANDOM=1
   SET /A RANDOM_PID_KEY=%RANDOM% %% %MAX_RANDOM%
   IF '%RANDOM_PID_KEY%'=='0' SET PID_KEY=YKHFT-KW986-GK4PY-FDWYH-7TP9F
   IF '%RANDOM_PID_KEY%'=='1' SET PID_KEY=
   IF '%RANDOM_PID_KEY%'=='2' SET PID_KEY=
   IF '%RANDOM_PID_KEY%'=='3' SET PID_KEY=
   IF '%RANDOM_PID_KEY%'=='4' SET PID_KEY=
GOTO :EOF


:ULTIMATE_KEY
   SET MAX_RANDOM=3
   SET /A RANDOM_PID_KEY=%RANDOM% %% %MAX_RANDOM%
   IF '%RANDOM_PID_KEY%'=='0' SET PID_KEY=22TKD-F8XX6-YG69F-9M66D-PMJBM
   IF '%RANDOM_PID_KEY%'=='1' SET PID_KEY=342DG-6YJR8-X92GV-V7DCV-P4K27
   IF '%RANDOM_PID_KEY%'=='2' SET PID_KEY=FJGCP-4DFJD-GJY49-VJBQ7-HYRR2
   IF '%RANDOM_PID_KEY%'=='3' SET PID_KEY=
   IF '%RANDOM_PID_KEY%'=='4' SET PID_KEY=
GOTO :EOF


:FINISH
ECHO finish:============================================================================================== >>%DEBUGLOG%
SHUTDOWN /R /T 0
EXIT