; 05/05/2002
; AT89C1051
;################# B I S M I L L A H ###################;

PMOD            REG             P1.5    ;PIN 17         1 PROGRAM MOD

POW             REG             P1.7    ;PIN 19         2 POWER SAVING

OTA             REG             P3.0    ;PIN 2          3 OUTPUT
OTB             REG             P3.1    ;PIN 3          4 OUTPUT

GRN             REG             P1.6    ;PIN 18         5 IND 5 MIN 

STB             REG             P3.7    ;PIN 11         6 STROBE

AAA             REG             P3.5    ;PIN 9          7
BBB             REG             P3.4    ;PIN 8          8
CCC             REG             P3.3    ;PIN 7          9
DDD             REG             P3.2    ;PIN 6          10

;-----------------------------------
;=         SERIAL EEPROM           =
;-----------------------------------
DO              REG             P1.0   ;PIN 12  DATA IN FOR 93C46
DI              REG             P1.1   ;PIN 13  DATA OUT FOR 93C46
SK              REG             P1.2   ;PIN 14  CLOCK FOR 93C46
CS              REG             P1.3   ;PIN 15  ENABLE FOR 93C46

RES             REG             31H
WAT             REG             32H
DAT             REG             33H
FLAG            REG             01H
CODA            REG             34H
COD2A           REG             35H
COD3A           REG             39H
CODB            REG             3AH
COD2B           REG             3BH
COD3B           REG             3CH
R6V             REG             36H
R7V             REG             37H
;-----------------------------------
;=            RAM FLAG             =
;-----------------------------------
SIZE            EQU             03H    ;0 = 8-bit data, 1 = 16-bit data
NADDR           EQU             7      ;e.g. AT93C46 strapped for 8-bit data.
;-----------------------------------
;       EEPROM ADDRESSES
;-----------------------------------
;       1    FOR    08
;       2    FOR    04
;       3    FOR    12
;       4    FOR    02
;       5    FOR    10
;       6    FOR    06
;       7    FOR    14
;       8    FOR    1
;       9    FOR    9
;===================================
;=        VALUE ASSIGNMENT         =
;===================================
DATA_LO         REG             R2  ;53H  register for byte data
DATA_HI         REG             R3  ;54H  extension register for word data
ADDR_LO         REG             R4  ;55H  register for short address
ADDR_HI         REG             R5  ;56H  extension register for long address


;               |||||||||| MAIN PROGRAM ||||||||||

                ORG             0000H
                LJMP            MAIN

                ORG             000BH
                LJMP            T0ISR

                ORG             0030H
MAIN:
;--+--+--+--+--+--+--+--+--+--+--+--+--+--+--
;--+--+--+--+--+--+--+--+--+--+--+--+--+--+--
;--+--+--+--+--+--+--+--+--+--+--+--+--+--+--
                CLR             POW
                SETB            PMOD

                CLR             OTA
                CLR             OTB

                SETB            STB

                SETB            AAA
                SETB            BBB
                SETB            CCC
                SETB            DDD

                MOV             R1,#06
                MOV             TH0,#3CH
                MOV             TL0,#B0H
                MOV             TMOD,#01H       ; TIMER 0 IN 16 BIT MODE.
                MOV             IE,#82H         ; ENABLE T0 INTRUPT.
                CLR             FLAG
                CLR             CS              ; low
                CLR             SK              ; low
                SETB            DI              ; high
                SETB            DO              ; high
; Initialize SIZE flag.
                CLR             SIZE            ; specify 8-bit data
;====================================================
;               ||||| START PROGRAM |||||
;=====================================================
JUMPER:
                JB              PMOD,JMPER
                CALL            DELAY2
                JB              PMOD,JMPER
                CALL            PROG_MOD
JMPER:
                CALL            LODCOD
;-----------------------------------
; FIVE MIN DELAY.
TIM_DLY:
                MOV             R6,#60
                MOV             R7,#05
INITIMER:
                SETB             TR0
                CLR              FLAG
                CLR              POW

TAKATIM:
                CJNE            R1,#05,GOSKIP
                SETB            GRN
GOSKIP:
                ;CHECKING CODE BYPASS

                JNB             STB,NOIN

                MOV             R0,#05

                CALL            DTMFDATA
                MOV             A,RES
                SWAP            A
                CJNE            A,#10,NOIN      ;"5"
                JB              STB,$

;----------------
LOPB:           JNB             STB,NOSTBB

                CALL            DTMFDATA
                MOV             A,RES
                SWAP            A
                CJNE            A,#10,NOIN      ;"5"
                JB              STB,$
                MOV             R0,#05
                SJMP            LOPC

NOSTBB:         CALL            DELAY2
                DJNZ            R0,LOPB
                
                SJMP            NOIN
;----------------
LOPC:           JNB             STB,NOSTCC

                CALL            DTMFDATA
                MOV             A,RES
                SWAP            A
                CJNE            A,#10,NOIN      ;"5"
                CLR             POW
                SJMP            STARTTT

NOSTCC:         CALL            DELAY2
                DJNZ            R0,LOPC
                SJMP            NOIN
;----------------
NOIN:
                JNB             FLAG,TAKATIM
                CLR             GRN
                CLR             FLAG
                DJNZ            R6,INITIMER
                MOV             R6,#60
                CLR             FLAG
                DJNZ            R7,INITIMER
                MOV             R7,#05
                CLR             FLAG
                CLR             TR0
                CLR             TF0
                CLR             POW
;-----------------------------------
STARTTT:
                SETB            GRN
                MOV             R6,#03H
STARTT:
                SETB            TR0
                CLR             FLAG
STARTB:
                JB              STB,OUTA
                JNB             FLAG,STARTB
                CLR             FLAG
                DJNZ            R6,STARTT
                CLR             TR0
                CLR             POW
                CALL            DELAY2
                CALL            DELAY2
                CALL            LODCOD
;-----------------------------------
STARTC:
                SETB            TR0 
                CLR             FLAG
                SETB            GRN

STARTD:
                CLR             POW
                JNB             STB,OUTAB
                CALL            DELAY2
                JNB             STB,OUTAB
                SJMP            OUTA
OUTAB:          JNB             FLAG,STARTD
                CLR             FLAG
                MOV             R6,#03H
                CLR             TR0
                SJMP            STARTTT
OUTA:
                CLR             TR0
                CLR             POW
                SETB            GRN
                CALL            DTMFDATA
                MOV             A,RES
                SWAP            A

                CJNE            A,#13,OUTB      ; #
                JB              STB,$
                CLR             GRN
                CALL            A_PART
                SETB            GRN
HO2M:           JB              STB,$
                SJMP            STARTTT
                JNB             STB,$

                CLR             TR0
                CLR             POW
                CALL            DTMFDATA
                MOV             A,RES
                SWAP            A
                CJNE            A,#03,HO2M           ;*

                CALL            B_PART
                SJMP            $
OUTB:
                CJNE            A,#03,STARTTT    ; *
                JB              STB,$
                CLR             GRN
                CALL            B_PART
                SETB            GRN
HO3M:           JB              STB,$
                LJMP            STARTTT
                JNB             STB,$

                CLR             TR0
                CLR             POW
                CALL            DTMFDATA
                MOV             A,RES
                SWAP            A
                CJNE            A,#13,HO3M      ; #

                CALL            A_PART

                SJMP            $
;=====================================================
A_PART:
                JNB              STB,$

                CALL            DTMFDATA
                MOV             A,RES
                SWAP            A
                CJNE            A,#05,ON_A       ; 0
DOAGNA:
                JB              STB,$
                JNB             STB,$
                   
                CALL            DTMFDATA
                MOV             A,RES
                CJNE            A,CODA,EXIT_A

                JB              STB,$
                JNB             STB,$
                             
                CALL            DTMFDATA
                MOV             A,RES
                CJNE            A,COD2A,EXIT_A

                JB              STB,$
                JNB             STB,$
                             
                CALL            DTMFDATA
                MOV             A,RES
                CJNE            A,COD3A,EXIT_A

                CLR             OTA              ; IF CODE EXEIST
                JB              STB,$

                SJMP            EXIT_A
DOAGNB:
                JB              STB,$
                JNB             STB,$
                CALL            DTMFDATA
ON_A:
                MOV             A,RES
                CJNE            A,CODA,DOAGNB

                JB              STB,$           ; STB
                JNB             STB,$
                             
                CALL            DTMFDATA
                MOV             A,RES
                CJNE            A,COD2A,DOAGNB
                 
                JB              STB,$           ; STB
                JNB             STB,$
                             
                CALL            DTMFDATA
                MOV             A,RES
                CJNE            A,COD3A,DOAGNB

                SETB             OTA
                JB              STB,$
EXIT_A:
                RET
;=====================================================
B_PART:
                JNB             STB,$
                CALL            LODCOD
                CALL            DTMFDATA
                MOV             A,RES
                SWAP            A
                CJNE            A,#05,ON_B       ; 0
DOBPA:
                JB              STB,$
                JNB             STB,$

                CALL            DTMFDATA
                MOV             A,RES
                CJNE            A,CODB,EXIT_B

                JB              STB,$
                JNB             STB,$

                CALL            DTMFDATA
                MOV             A,RES
                CJNE            A,COD2B,EXIT_B

                JB              STB,$
                JNB             STB,$

                CALL            DTMFDATA
                MOV             A,RES
                CJNE            A,COD3B,EXIT_B

                CLR             OTB              ; IF CODE EXEIST
                JB              STB,$
                SJMP            EXIT_B
DOBPB:
                JB              STB,$
                JNB             STB,$
                CALL            DTMFDATA
ON_B:
                MOV             A,RES
                CJNE            A,CODB,DOBPB

                JB              STB,$
                JNB             STB,$

                CALL            DTMFDATA
                MOV             A,RES
                CJNE            A,COD2B,DOBPB

                JB              STB,$
                JNB             STB,$

                CALL            DTMFDATA
                MOV             A,RES
                CJNE            A,COD3B,DOBPB

                SETB             OTB
EXIT_B:
                RET
;=====================================================
LODCOD:
                MOV             ADDR_LO,#00H    ; address CODE VALUE
                CALL            READ
                MOV             CODA,DATA_LO
                MOV             A,CODA
                ANL             A,#F0H
                MOV             CODA,A


                MOV             ADDR_LO,#01H    ; address CODE VALUE
                CALL            READ
                MOV             COD2A,DATA_LO
                MOV             A,COD2A
                ANL             A,#F0H
                MOV             COD2A,A


                MOV             ADDR_LO,#02H    ; address CODE VALUE
                CALL            READ
                MOV             COD3A,DATA_LO
                MOV             A,COD3A
                ANL             A,#F0H
                MOV             COD3A,A

                MOV             ADDR_LO,#03H    ; address CODE VALUE
                CALL            READ
                MOV             CODB,DATA_LO
                MOV             A,CODB
                ANL             A,#F0H
                MOV             CODB,A

                MOV             ADDR_LO,#04H    ; address CODE VALUE
                CALL            READ
                MOV             COD2B,DATA_LO
                MOV             A,COD2B
                ANL             A,#F0H
                MOV             COD2B,A

                MOV             ADDR_LO,#05H    ; address CODE VALUE
                CALL            READ
                MOV             COD3B,DATA_LO
                MOV             A,COD3B
                ANL             A,#F0H
                MOV             COD3B,A
                RET
;=====================================================
PROG_MOD:
                CLR             POW
GETDATA:
                JNB             STB,$
                SETB            GRN
                CALL            DTMFDATA
                MOV             A,RES
                SWAP            A
                CJNE            A,#13,GETDATAB      ; #
                LJMP            HASH
GETDATAB:
                SETB            GRN
                CALL            DTMFDATA
                MOV             A,RES
                SWAP            A
                CJNE            A,#03,GETDATA      ; *
                LJMP            STARIK

HASH:           JB              STB,$   ; IF PRESSED
                JNB             STB,$    ; WAIT FOR NEXT COMMAND

                CALL            DTMFDATA
                MOV             CODA,RES

;               STORING....

                CALL            EWEN
                MOV             ADDR_LO,#00H     ; CODE A address
                MOV             DATA_LO,CODA
                CALL            WRITE

                JB              STB,$
                JNB             STB,$
                             
                CALL            DTMFDATA
                MOV             CODA,RES

;               STORING....

                MOV             ADDR_LO,#01H     ; CODE A address
                MOV             DATA_LO,CODA
                CALL            WRITE

                JB              STB,$
                JNB             STB,$

                CALL            DTMFDATA
                MOV             CODA,RES

;               STORING....

                CALL            EWEN
                MOV             ADDR_LO,#02H     ; CODE A address
                MOV             DATA_LO,CODA
                CALL            WRITE

                JB              STB,$
                JNB             STB,$

                CALL            EWDS

                JB              STB,$
                CLR             GRN
                JNB             STB,$
                LJMP            GETDATA

STARIK:         JB              STB,$   ; IF PRESSED
                JNB             STB,$    ; WAIT FOR NEXT COMMAND

                CALL            DTMFDATA
                MOV             CODB,RES

;               STORING....

                CALL            EWEN
                MOV             ADDR_LO,#03H     ; CODE A address
                MOV             DATA_LO,CODB
                CALL            WRITE

                JB              STB,$
                JNB             STB,$
                             
                CALL            DTMFDATA
                MOV             CODB,RES

;               STORING....

                MOV             ADDR_LO,#04H     ; CODE A address
                MOV             DATA_LO,CODB
                CALL            WRITE

                JB              STB,$
                JNB             STB,$

                CALL            DTMFDATA
                MOV             CODB,RES

;               STORING....

                CALL            EWEN
                MOV             ADDR_LO,#05H     ; CODE A address
                MOV             DATA_LO,CODB
                CALL            WRITE

                JB              STB,$
                JNB             STB,$

                CALL            EWDS

                JB              STB,$
                CLR             GRN
                JNB             STB,$
                LJMP            GETDATA
;=====================================================
DTMFDATA:
                MOV             C,AAA
                MOV             E7H,C

                MOV             C,BBB
                MOV             E6H,C

                MOV             C,CCC
                MOV             E5H,C

                MOV             C,DDD
                MOV             E4H,C

                ANL             A,#F0H
                MOV             RES,A
                RET
;=====================================================
T0ISR:          CLR             TF0
                CLR             FLAG
                DJNZ            R1,SKIP
                MOV             R1,#06      ;20
                SETB            FLAG
                CLR             TR0
                MOV             TH0,#3CH     ; EQUAL TO 50000D
                MOV             TL0,#B0H
                LJMP            EXIT
SKIP:
                MOV             TH0,#3CH     ; EQUAL TO 50000D
                MOV             TL0,#B0H
                SETB            TR0
EXIT:
                RETI
;=====================================================
DELAY2:         MOV             R6V,R6
                MOV             R7V,R7
                MOV             R7,#FFH
AASD:           MOV             R6,#FFH
                DJNZ            R6,$
                DJNZ            R7,AASD
                MOV             R6,R6V
                MOV             R7,R7V
                RET
;=====================================================
;===================================
;=        AT93CXX ROUTEEN          =
;===================================                                                                0110 0111
READ:
                SETB            CS
                MOV             DPL, #110B
                MOV             B, #3
                CALL            OUTDATA
                MOV             DPL, ADDR_LO    ; LOW BYTE
                MOV             DPH, ADDR_HI    ; HIGH BYTE (MAY BE UNDEFINED)
                MOV             B, #NADDR       ; BIT COUNT
                CALL            OUTDATA
                CALL            INDATA          ; GET RETURN DATA
                CLR             CS              ; DROP CS
                RET
WRITE:
                SETB            CS
                MOV             DPL, #101B
                MOV             B, #3
                CALL            OUTDATA
                MOV             DPL, ADDR_LO    ; LOW BYTE
                MOV             DPH, ADDR_HI    ; HIGH BYTE (MAY BE UNDEFINED)
                MOV             B, #NADDR       ; BIT COUNT
                CALL            OUTDATA
                MOV             DPL, DATA_LO
                JB              SIZE, EE61
                MOV             B, #8
                JMP             EE62
EE61:           MOV             DPH, DATA_HI
                MOV             B, #16
EE62:           CALL            OUTDATA
                CLR             CS              ; DROP CS
                CALL            STATUS          ; RETURNS CY
                RET
WRAL:           SETB            CS
                MOV             DPTR, #0220H    ; (10001B SHL (NADDR-2))
                MOV             B, #(NADDR+3)
                CALL            OUTDATA
                MOV             DPL, DATA_LO
                JB              SIZE, EE71
                MOV             B, #8
                JMP             EE72
EE71:           MOV             DPH, DATA_HI
                MOV             B, #16
EE72:           CALL            OUTDATA
                CLR             CS              ; DROP CS
                CALL            STATUS          ; RETURNS CY
                RET
ERASE:          SETB            CS
                MOV             DPTR, #111B
                MOV             B, #3
                CALL            OUTDATA
                MOV             DPL, ADDR_LO    ; LOW BYTE
                MOV             DPH, ADDR_HI    ; HIGH BYTE (MAY BE UNDEFINED)
                MOV             B, #NADDR       ; BIT COUNT
                CALL            OUTDATA
                CLR             CS              ; DROP CS
                CALL            STATUS          ; RETURNS CY
                RET
ERAL:           SETB            CS
                MOV             DPTR, #0240H    ;(10010B SHL (NADDR-2))
                MOV             B, #(NADDR+3)
                CALL            OUTDATA
                CLR             CS              ; DROP CS
                CALL            STATUS          ; RETURNS CY
                RET
EWEN:           SETB            CS
                MOV             DPTR, #0260H    ;(10011B SHL (NADDR-2))
                MOV             B, #(NADDR+3)
                CALL            OUTDATA
                CLR             CS              ; DROP CS
                RET
EWDS:           SETB            CS
                MOV             DPTR, #0200H    ; (10000B SHL (NADDR-2))
                MOV             B, #(NADDR+3)
                CALL            OUTDATA
                CLR             CS              ; DROP CS
                RET
STATUS:         PUSH            B
                SETB            DO              ; FLOAT PIN
                SETB            CS
                MOV             B, #220         ; 220 * 50 US = 11 MS
EE40:           PUSH            B               ; 2 US
                MOV             B, #22          ; 2 US
                DJNZ            B, $            ; 2 US * 22
                POP             B               ; 2 US
                JB              DO, EE41        ; JUMP IF DO IS HIGH (READY)
                DJNZ            B, EE40         ; NEXT PASS
                SETB            C               ; FLAG ERROR
                JMP             EE42            ; RETURN
EE41:           CLR             C               ; CLEAR ERROR FLAG
EE42:           CLR             CS              ; DESELECT DEVICE
                POP             B
                RET
INDATA:         SETB            DO              ; FLOAT PIN
                CALL            SHIN
                JNB             SIZE, EE21      ; JUMP IF DATA IS ONLY ONE BYTE WIDE
                MOV             DATA_HI, A      ; SAVE HIGH BYTE
                CALL            SHIN
EE21:           MOV             DATA_LO, A      ; SAVE LOW BYTE
                RET
SHIN:           PUSH            B
                CLR             SK              ; DROP CLOCK
                MOV             B, #8           ; INIT LOOP / DELAY MIN ONE US
EE30:           SETB            SK              ; RAISE CLOCK
                NOP                     ; DELAY MIN ONE US
                MOV             C, DO           ; READ SERIAL DATA OUTPUT
                RLC             A               ; SHIFT IN BIT / DELAY MIN ONE US
                CLR             SK              ; DROP CLOCK
                DJNZ            B, EE30         ; NEXT BIT / DELAY MIN ONE US
                POP             B
                RET
OUTDATA:        PUSH            B
                MOV             A, B            ; GET BIT COUNT
                CLR             C               ; COMPARE COUNT TO EIGHT
                SUBB            A, #8           ;
                JC              EE6             ; JUMP IF COUNT LESS THAN EIGHT
                JZ              EE5             ; JUMP IF COUNT EQUALS EIGHT
                MOV             B, A            ; SAVE ADJUSTED BIT COUNT
                CLR             C               ; COMPARE ADJUSTED COUNT TO EIGHT
                SUBB            A, #8           ;
                JC              EE2             ; JUMP IF COUNT LESS THAN EIGHT
                JNZ             EE9             ; JUMP IF COUNT GREATER THAN EIGHT
                MOV             A, DPH
                JMP             EE4
EE2:            PUSH            B               ; SAVE COUNT
                MOV             A, DPH          ; GET DATA
EE3:            RR              A               ; SHIFT DATA
                DJNZ            B, EE3          ;
                POP             B               ; RESTORE COUNT
EE4:            CALL            SHOUT
                MOV             B, #8
EE5:            MOV             A, DPL
                JMP             EE8
EE6:            PUSH            B               ; SAVE COUNT
                MOV             A, DPL          ; GET DATA
EE7:            RR              A               ; SHIFT DATA
                DJNZ            B, EE7          ;
                POP             B               ; RESTORE COUNT
EE8:            CALL            SHOUT
EE9:            SETB            DO              ; LEAVE PIN FLOATING
                POP             B
                RET
SHOUT:          
EE50:           CLR             SK              ; DROP CLOCK
                RLC             A               ; MOVE BIT INTO CY
                MOV             DI, C           ; OUTPUT BIT
                NOP                             ; DELAY MIN 400 NS
                SETB            SK              ; RAISE CLOCK
                DJNZ            B, EE50         ; NEXT BIT / DELAY MIN ONE US
                CLR             SK              ; DROP CLOCK
                RET
;======================================
 END
;======================================
