if (typeof OV == "undefined" || !OV) {
    var OV = {};
}

OV.flagger = {};

var contentFlagger;

defineFlagger = function() {
	contentFlagger = new YAHOO.widget.Panel("contentFlagger", { 
			width: "400px",
		    constraintoviewport: true,  
			modal:false,
		    fixedcenter: true,
		    underlay:"shadow",  
		    close:true,  
		    visible: false,  
		    draggable: true } );
	
	contentFlagger.render();
}

OV.flagger.loggedIn = YAHOO.util.Cookie.get("logged_in") != null;

OV.flagger.showContentFlagger = function(e, args) {
	YAHOO.util.Event.stopEvent(e);
	if (!OV.flagger.loggedIn) {
		window.location = "/session/new";
		return;
	}
	var id = args[0];
	if (args[1]) var type = args[1];
	else var type = 'Comment';
	
	contentFlagger.show();
	YAHOO.util.Dom.get("abuse_report_flaggable_id").value = id;
	YAHOO.util.Dom.get("abuse_report_flaggable_type").value = type;
	//Clear out the other fields
	YAHOO.util.Dom.get("abuse_report_description").value = "";
	YAHOO.util.Dom.get("abuse_report_abuse_type_id").selectedIndex = 0;
}

OV.flagger.noPrivileges = function(e) {
	YAHOO.util.Event.preventDefault(e);
	window.location = "/session/new";
}

OV.flagger.submitAbuseReport = function(e) {
	YAHOO.util.Event.preventDefault(e);
	var reportUrl = "/moderation/report_abuse?abuse_report[abuse_type_id]=" + YAHOO.util.Dom.get("abuse_report_abuse_type_id").value + "&abuse_report[description]=" + YAHOO.util.Dom.get("abuse_report_description").value + "&abuse_report[flaggable_id]=" + YAHOO.util.Dom.get("abuse_report_flaggable_id").value + "&abuse_report[flaggable_type]=" + YAHOO.util.Dom.get("abuse_report_flaggable_type").value
	var infoObj = YAHOO.util.Connect.asyncRequest('GET', reportUrl, OV.flagger.reportAbuseCallback);
	OV.loading.showSpinner("spinner", "contentFlaggerBody");
}

OV.flagger.reportAbuseCallback = {
  success: function(o) {
    contentFlagger.hide();
	OV.loading.hideSpinner("spinner", "contentFlaggerBody");
    alert(o.responseText);
	
  },
  failure: function(o) {
  	contentFlagger.hide();
	OV.loading.hideSpinner("spinner", "contentFlaggerBody");
    alert('error');
  }
};