//////////////////////////////////////////////////////////////////////////////
// Functions for Ajax Windows /////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
/* This function is called when a user clicks on a button to open (launch) some Ajax Window. */
/* Attempts to load an instance of the window if it is not already created. */
var show_ajax_window = function(el, window) {
	// Return if the attributes object has not been defined for this obj
	if (typeof ajax_window_elements == 'undefined') {alert('Window attributes not found: ' + el); return;}
	if (typeof ajax_window_elements[window] == 'undefined') {alert('Window attributes not found: ' + el); return;}
	
	// See if the main js file has already been loaded
	var js_already_loaded = false;
	var eval_str = "if (typeof " + ajax_window_elements[window][el].main_js_classname + "_loaded != 'undefined' && " +
	               "typeof Mod_ajax_window_loaded != 'undefined') {js_already_loaded = true;}";
	eval(eval_str);
	
	// Get attributes object
	var cur_attr = ajax_window_elements[window][el];
	
	// Create an element to show a loading indicator (if not already created)
	if (!document.getElementById(el)) {
		if (cur_attr.display_position == 'relative') {
			var container_attr = {
				'width'      : '100%',
				'position'   : 'relative'
			};
		}
		else {
			// Get window height so we can set the top position correctly
			var myHeight = 0;
			if( typeof( window.innerWidth ) == 'number' ) {
				myHeight = window.innerHeight; //Non-IE
			}
			else if( document.documentElement && ( document.documentElement.clientWidth || document.documentElement.clientHeight ) ) {
				myHeight = document.documentElement.clientHeight; //IE 6+ in 'standards compliant mode'
			}
			
			// Get vertical scroll position to help center window
			var n_win = window.pageYOffset ? window.pageYOffset : 0;
			var n_docel = document.documentElement ? document.documentElement.scrollTop : 0;
			var n_body = document.body ? document.body.scrollTop : 0;
			var n_result = n_win ? n_win : 0;
			if (n_docel && (!n_result || (n_result > n_docel))) {
				n_result = n_docel;
			}
			var scroll_top = n_body && (!n_result || (n_result > n_body)) ? n_body : n_result;
			
			// Do the math
			var top = (myHeight / 2) - (cur_attr.container_height / 2) + scroll_top;
			if (top < 0) {top = 0;}
			
			var margin_left_value = (document.body.offsetWidth - cur_attr.container_width) / 2;
			if (margin_left_value < 0) margin_left_value = 0;
			var container_attr = {
				'width'      : cur_attr.container_width + 'px',
				'height'     : cur_attr.container_height + 'px',
				'position'   : 'absolute',
				'top'        : top + 'px',
				'left'       : '0',
				'marginLeft' : margin_left_value + 'px',
				'border'     : '1px solid #bbbbbb',
				'background' : 'white'
			};
		}
		SiteUtil.createContainer(el, container_attr, cur_attr.parent_el);
		SiteUtil.showLoading(el, cur_attr.loading_image_url);
	}
	
	// Skip loading js file if already loaded
	if (js_already_loaded) {
		// Get Window object
		eval_str = "var window_obj = " + ajax_window_elements[window][el].main_js_classname + ".singleton(el, ajax_window_elements[window][el]);";
		eval(eval_str);
		focus();
		window_obj.show();
		return;
	}
	
	// See if the window js file has already been loaded
	if (typeof Mod_ajax_window == "undefined") {
		SiteUtil.dynamicLoadFile(cur_attr.aw_js_url, 'js');
	}
	
	// Otherwise, we need to load main js file
	SiteUtil.dynamicLoadFile(cur_attr.main_js_url, 'js');
	
	// Now wait for media_manager.js to load
	setTimeout(function() {
		show_ajax_window_wait(el, window);
	}, 150);
};
var show_ajax_window_wait = function(el, window) {
	// See if js file is loaded
	var js_already_loaded = false;
	var eval_str = "if (typeof " + ajax_window_elements[window][el].main_js_classname + "_loaded != 'undefined' && " +
	               "typeof Mod_ajax_window_loaded != 'undefined') {js_already_loaded = true;}";
	eval(eval_str);
	
	// Wait longer if still not loaded
	if (!js_already_loaded) {
		// Wait .4 seconds and try again
		setTimeout(function() {
			show_ajax_window_wait(el, window);
		}, 400);
		return;
	}
	
	// Get Window object
	eval_str = "var window_obj = " + ajax_window_elements[window][el].main_js_classname + ".singleton(el, ajax_window_elements[window][el]);";
	eval(eval_str);
	focus();
	window_obj.show();
};

/**
 * Provides handy utilities used by other js files.
 * Defines several static methods that can be called like this:
 *   SiteUtil.methodName(var1);
 * 
 * @class SiteUtil
 */
SiteUtil = function() {
	
	return {
		
		/**
		 * Method goes here...
		 */
		showLoading: function(el, loading_image, attr) {
			// Get parent el
			var element = document.getElementById(el);
			element.style.display = 'block';
			
			// Build container for loading image
			var container = document.createElement('div');
			container.id = el + '_loadingimage';
			container.className = 'site_loadingimage';
			container.style.position = 'absolute';
			container.style.top = '1px';
			container.style.left = '1px';
			container.style.width = '99%';
			container.style.textAlign = 'center';
			container.style.zIndex = '500';
			container.innerHTML = "<img src='" + loading_image + "' />";
			
			// Assign each custom style attribute
			for (var elstyle in attr) {
				var eval_str = "container.style." + elstyle + " = '" + attr[elstyle] + "';";
				eval(eval_str);
			}
			
			//element.appendChild(container);
			element.insertBefore(container, element.firstChild);
		},
		
		/**
		 * Dynamically loads a file of type 'type' (js/css) anytime during 
		 * program execution.
		 * 
		 * @param String url   URL of file to load
		 * @param String type  Type of file being loaded [js, css]
		 */
		dynamicLoadFile: function(url, type) {
			if (type == 'js') {
				var e = document.createElement("script");
				e.type = "text/javascript";
				e.src = url;
			}
			else if (type == 'css') {
				var e = document.createElement("link");
				e.type = "text/css";
				e.rel = "stylesheet";
				e.href = url;
			}
			else { return; }
			
			// Append file to header
			document.getElementsByTagName("head")[0].appendChild(e);
		}, 
		
		/**
		 * Get the HTMLElement for the given id.
		 * 
		 * @param String el   Id of the element we want to get
		 */
		$: function(el) {
			return document.getElementById(el);
		},
		
		/**
		 * Attempt to create a new container (div) and append it to the parent.
		 *
		 * @param id         element_id of the new container
		 * @param attr       object of style properties to set
		 * @param parent_el  parent id to append new container to (or: document.body)
		 */
		createContainer: function(id, attr, parent_el) {
			// Create new element
			var container = document.createElement('div');
			container.id = id;
			container.className = 'siteUtilContainer';
			container.style.display = 'none';
			container.style.zIndex = '9999';
			
			// Assign each custom style attribute
			for (var elstyle in attr) {
				var eval_str = "container.style." + elstyle + " = '" + attr[elstyle] + "';";
				eval(eval_str);
			}
			
			// Get parent element
			if (parent_el == 'document.body') {
				parent_el = document.body;
			}
			else {
				parent_el = document.getElementById(parent_el);
			}
			
			// Append new element to parent
			parent_el.appendChild(container);
		}
	};
	
}();