function observe_main_ask_a_question_form_to_reveal_question_types() {
  new Form.Element.Observer('title_question', 0.3, function(form, value) {
    $("choose_your_question_type").show() ;
  }) ;
}

function build_observer(browser, button) {
  new Form.Element.Observer(browser, 0.3, function(form, value) {
    $(button).click() ;
  }) ;
}

function observe_ask_a_question_upload_forms() {
  build_observer("file_upload_browser_main", "main_file_upload_submit_button") ;

  $R(0,4).each(function(number) {
    build_observer("file_upload_browser_side_" + number,
                   "side_" + number + "_file_upload_submit_button") ;
  })
}

function observe_answer_question_upload_form() {
  build_observer("file_upload_browser_main", "main_file_upload_submit_button") ;
}

function observe_write_piece_upload_form() {
  build_observer("file_upload_browser_main", "main_file_upload_submit_button") ; // DRY!
}

function observe_form_poll_type_radios() {
// observe click event for poll type radio buttons as IE doesn't fire OnChange nicely
  Event.observe("question_type_radio_open", "click", choose_open_question_type);
  Event.observe("question_type_radio_head", "click", choose_head_to_head_question_type);
  Event.observe("question_type_radio_multi", "click", choose_multiple_choice_question_type);
}

function display_question_type() {
  a_question_form = $("whats_your_question");
  $("question_type_radio_multi").checked = true;
}

function unghost(div, default_text) {
  if ($(div).value == default_text) {
    $(div).value = '' ;
  }
  $(div).removeClassName('ghosted') ; 
  $(div).addClassName('unghosted') ; 
}

function set_type(type) {
//  alert(type);
  $("question_type").value = type ;
  
  if ("head_to_head" == type) {
    $("question_type_radio_head").checked = true;
  } else if ("multiple_choice" == type) {
    $("question_type_radio_multi").checked = true;
  } else {
    $("question_type_radio_open").checked = true;
  }
  
}

function choose_head_to_head_question_type() {
  set_type("head_to_head") ;

  $('sides').show() ;

  $('side_0').show() ;
  $('side_1').show() ;

  $('side_2').hide() ;
  $('side_2_text').value = '' ;

  $('side_3').hide() ;
  $('side_3_text').value = '' ;

  $('side_4').hide() ;
  $('side_4_text').value = '' ;

  $('show_another_0').hide() ;
  $('show_another_1').hide() ;
  $('sides_displayed').value="2"
}

function choose_multiple_choice_question_type() {
  set_type("multiple_choice") ;

  $('sides').show() ;

  $('side_0').show() ;
  $('side_1').show() ;
  $('side_2').show() ;

  $('side_3').hide() ;
  $('side_4').hide() ;

  $('show_another_0').show() ;
  $('sides_displayed').value="3"
}

function choose_open_question_type() {
  set_type("open");

  $('sides').hide();

  $('side_0').hide();
  $('side_1').hide();
  $('side_2').hide();
  $('side_3').hide();
  $('side_4').hide();

  $('show_another_0').hide() ;
  $('show_another_1').hide() ;

  $('side_0_text').value = '' ;
  $('side_1_text').value = '' ;
  $('side_2_text').value = '' ;
  $('side_3_text').value = '' ;
  $('side_4_text').value = '' ;
  $('sides_displayed').value="0"
}

function show_another_0() {
  $('side_3').show() ;
  $('show_another_0').hide() ;
  $('show_another_1').show() ;
  $('sides_displayed').value="4"
}

function show_another_1() {
  $('side_4').show() ;
  $('show_another_1').hide() ;
  $('sides_displayed').value="5"
}

// character counters for each text field/area
var CharacterCounter = Class.create({
  initialize: function(textarea, charCount, limit){
    var textarea = $(textarea);
    var charCount = $(charCount);

	if ( textarea != null && charCount != null) {
	    var updateDisplay = function(){
	      var left = limit - textarea.value.length;
	      charCount.update(left);
	      if (left < 0){
	        charCount.addClassName('invalid');
	      }else{
	        charCount.removeClassName('invalid');
	      }
	    }
	    textarea.observe('keyup', updateDisplay);
	    updateDisplay();
	}
  }
}) ;

function set_up_character_counters() {
  new CharacterCounter('title_question', 'character_counter_for_question', 120);
  new CharacterCounter('side_0_text', 'character_counter_for_side_0', 40);
  new CharacterCounter('side_1_text', 'character_counter_for_side_1', 40);
  new CharacterCounter('side_2_text', 'character_counter_for_side_2', 40);
  new CharacterCounter('side_3_text', 'character_counter_for_side_3', 40);
  new CharacterCounter('side_4_text', 'character_counter_for_side_4', 40);
}
function set_up_character_counters_write_page() {
  new CharacterCounter('title_piece', 'character_counter_for_piece', 120);
}

function set_up_answer_form_character_counters() {
  new CharacterCounter('answer_title', 'character_counter_for_answer_title', 120) ;
}

// this should very, VERY likely be object-oriented. I'm not happy with this code. I'll need to fix it.
function add_input_to_answer_form(form, input_name, input_id) {
  form.insert(Builder.node("input",
                           {type:"hidden",
                            name:(input_name),
                            value:$(input_id).value})) ;
}

function make_question_form_submit_parameters() {
	var h = new Hash();
	
	var page_fields_to_set=[ 'asked_id', 're_class', 're_id' ];
	page_fields_to_set.each( function(i) {
		if ( $(i) != null) {
			h.set(i, $(i).value);
		}
	  }
	);

	h.set("question[topic_id]", $('topic_id').value);
	h.set("question[question_type]", $('question_type').value);
	h.set("question[title]", $("title_question").value);
	h.set("question[attachment_id]", $('main_attachment_id').value); 
	h.set("question[highly_related_list]", $("tag_list").value);
	h.set("question[html_raw]", tinyMCE.get('description').getContent({format : 'html'})); 
	
	if ($('sides_displayed')!=null) {
		sides_shown = parseInt($('sides_displayed').value);
		if (sides_shown>0) {
			for (s=0; s < sides_shown; s=s+1) {
				if ($('option_'+s+'_id')!=null) {
					h.set("sides["+s+"[id]]", $( 'option_'+s+'_id' ).value);
				}
				h.set("sides["+s+"[attachment_id]]", $( 'side_'+s+'_attachment_id' ).value);
				h.set("sides["+s+"[title]]", $( 'side_'+s+'_text' ).value);
			}
		}
	}	
	
	var ed_fields_to_set=[
		'headline',
		'byline', 
		'url',
		'summary',
		'also_related_list'
	];

	if ($('editorialFields')!=null) {
		ed_fields_to_set.each( function(i) {
			h.set("question["+i+"]", $(i).value);
		  }
		);
	}
	
	return h.toQueryString();
}

function make_answer_form_submit_parameters() {
	var h = new Hash();

	h.set("question_id", $('question_id').value);
	h.set("attachment_main_id", $('main_attachment_id').value);
	h.set("answer[title]", $('answer_title').value);
	h.set("answer[html_raw]", tinyMCE.get('answer_detail').getContent({format : 'html'}))
	
  if ($("radio_button_collection") != null ) {
    poll_selection_id = $("radio_button_collection").getInputs("radio").find(
      function(radio) {
        return radio.checked
      }).value

	h.set("poll_option_selected", poll_selection_id);
  }

  return h.toQueryString();
}



function main_answer_a_question_form_submit(draft_mode) {
  form = $("ask_a_question_form_that_actually_submits") ;
  if (draft_mode) {
    form.insert(Builder.node("input",
                             {type:"hidden",
                              name:("draft"),
                              value:"true"})) ;
  }

  add_input_to_answer_form(form, "answer[title]", "answer_title") ;
  form.insert(Builder.node("input",
                           {type:"hidden",
                            name:("answer[html_raw]"),
                            value:tinyMCE.get("answer_detail").getContent()})) ;

  // http://rexchung.com/2007/02/22/getting-radio-buttons-value-with-prototypejs/
  // if the radio button collection exists - because it won't if the question's open - determine what the user selected.
  if (!(null == $("radio_button_collection"))) {
    poll_selection_id = $("radio_button_collection").getInputs("radio").find(
      function(radio) {
        return radio.checked
      }).value

    form.insert(Builder.node("input",
                             {type:"hidden",
                              name:"poll_selection[poll_option_id]",
                              value:poll_selection_id})) ;
  }

  // add_input(form, "tags") ;

  form.submit() ;
}
