if (typeof OV == "undefined" || !OV) {
    var OV = {};
}

var clickedDD1 = false;
var showingDD1 = false;
var clickedDD2 = false;
var showingDD2 = false;

OV.comments = {};

OV.comments.argumentsHash = new Array();

OV.comments.commentFormHtml = "";

OV.comments.rootCommentDepth = 0;

OV.comments.initialForm = null;

OV.comments.loggedIn = YAHOO.util.Cookie.get("logged_in") != null;

OV.comments.storeForm = function(question_id) {
  var url = '/comments/comment_form';
  if (question_id != null) url += '?question_id='+question_id;
  var cObj = YAHOO.util.Connect.asyncRequest('GET', url, OV.comments.storeFormCallback);
};

OV.comments.storeFormCallback = {
  success: function(o) {
    OV.comments.commentFormHtml = o.responseText;
    if (OV.comments.initialForm) OV.comments.showForm(null, OV.comments.initialForm);
  },
  failure: function(o) {
  }
};

OV.comments.controller = function(e) {
  var target = YAHOO.util.Event.getTarget(e);
  //If this is an image inside of an anchor, the listener will be on the anchor
  if (target.nodeName.toLowerCase() == 'img' && target.parentNode.nodeName.toLowerCase() == 'a') target = target.parentNode;
  if (target.id != null) {
    //Get the function and arguments from the hash, based on dom ID
    var args = OV.comments.getControllerArguments(target.id);
    if (args != null) {
      YAHOO.util.Event.stopEvent(e);
      //First arg is the function to call, second is the arguments to pass to it
      args[0](e, args[1]);
    }
  }
};

OV.comments.getControllerArguments = function(domId) {
  //See if it is in the hash first
  // If not, infer args from domId
  if (typeof(OV.comments.argumentsHash[domId]) != 'undefined') {
    return OV.comments.argumentsHash[domId];
  } else if (domId.indexOf("reportAbuse") == 0) {
    return [OV.flagger.showContentFlagger, [OV.comments.getIdFromDomId(domId, "reportAbuse")]];
  } else if (domId.indexOf("showForm") == 0) {
    return [OV.comments.showForm, [OV.comments.getIdFromDomId(domId, "showForm")]];
  } else if (domId.indexOf("submitForm") == 0) {
    return [OV.comments.submitForm, [OV.comments.getIdFromDomId(domId, "submitForm")]];
  } else if (domId.indexOf("user_vote_link_") == 0) {
    return [OV.voter.castVote, [OV.comments.getIdFromDomId(domId, "user_vote_link_"), "Comment"]];
  } else {
    return null;
  }
};

OV.comments.getIdFromDomId = function(domId, prefix) {
  return domId.substring(prefix.length, domId.length);
};

OV.comments.hideDD = function(e){
  if (clickedDD1) {
    clickedDD1=false;
  } else {
    YAHOO.util.Dom.addClass('dropDown1', 'hide');
    showingDD1=false;
  }
  if (clickedDD2) {
    clickedDD2=false;
  } else {
    YAHOO.util.Dom.addClass('dropDown2', 'hide');
    showingDD2=false;
  }
};

OV.comments.showDD = function(e, which) {
  if (eval('showingDD'+which) != true) {
    eval('clickedDD'+which+'=true');
    eval('showingDD'+which+'=true');
    YAHOO.util.Dom.removeClass('dropDown'+which, 'hide');
  }
};

OV.comments.selectSortDD = function(e, cssClass) {
  if (YAHOO.util.Dom.hasClass('DDFilter1', 'ddSortRating') && 'ddSortRating' != cssClass) YAHOO.util.Dom.removeClass('DDFilter1', 'ddSortRating');
  if (YAHOO.util.Dom.hasClass('DDFilter1', 'ddSortOldest') && 'ddSortOldest' != cssClass) YAHOO.util.Dom.removeClass('DDFilter1', 'ddSortOldest');
  if (YAHOO.util.Dom.hasClass('DDFilter1', 'ddSortLatest') && 'ddSortLatest' != cssClass) YAHOO.util.Dom.removeClass('DDFilter1', 'ddSortLatest');
  YAHOO.util.Dom.addClass('DDFilter1', cssClass);
};

OV.comments.selectFilterDD = function(e, args) {
  var cssClass = args[0];
  var text = args[1];
  if (YAHOO.util.Dom.hasClass('DDFilter2', 'ddFilterBothSides') && 'ddFilterBothSides' != cssClass) YAHOO.util.Dom.removeClass('DDFilter2', 'ddFilterBothSides');
  if (YAHOO.util.Dom.hasClass('DDFilter2', 'ddFilterSide1') && 'ddFilterSide1' != cssClass) YAHOO.util.Dom.removeClass('DDFilter2', 'ddFilterSide1');
  if (YAHOO.util.Dom.hasClass('DDFilter2', 'ddFilterSide2') && 'ddFilterSide2' != cssClass) YAHOO.util.Dom.removeClass('DDFilter2', 'ddFilterSide2');
  if (YAHOO.util.Dom.hasClass('DDFilter2', 'ddFilterUncommitted') && 'ddFilterUncommitted' != cssClass) YAHOO.util.Dom.removeClass('DDFilter2', 'ddFilterUncommitted');
  YAHOO.util.Dom.addClass('DDFilter2', cssClass);
  YAHOO.util.Dom.get('DDFilter2').innerHTML = text;
};

OV.comments.expand = function(e, args) {
  YAHOO.util.Event.preventDefault(e);
  var id = args[0];
  var clazz = args[1];
  if (YAHOO.util.Dom.get("itemContent" + id).innerHTML == "") {
    //First time this one has been expanded, get it from the server
    var url = '/comments/get_parent_html?obj_id='+id+'&clazz='+clazz;
      var callback = {
	success: function(o) {
	  var expandItem = "expandItem"+o.argument;
	  var contractItem = "contractItem"+o.argument;
	  var expanded = "expanded"+o.argument;
	  var itemContent = "itemContent"+o.argument;
	  YAHOO.util.Dom.get(itemContent).innerHTML = o.responseText;
	  YAHOO.util.Dom.addClass(expandItem, 'hide');
	  YAHOO.util.Dom.removeClass(contractItem, 'hide');
	  YAHOO.util.Dom.removeClass(expanded, 'hide');
	},
	failure: function(o) {
	},
	argument: id,
	cache: false
      };
    var cObj = YAHOO.util.Connect.asyncRequest('GET', url, callback);
  } else {
    YAHOO.util.Dom.addClass('expandItem' + id, 'hide');
    YAHOO.util.Dom.removeClass('contractItem' + id, 'hide');
    YAHOO.util.Dom.removeClass('expanded' + id, 'hide');
  }
};

OV.comments.contract = function(e, id) {
  YAHOO.util.Event.preventDefault(e);
  YAHOO.util.Dom.addClass('contractItem'+id, 'hide');
  YAHOO.util.Dom.removeClass('expandItem'+id, 'hide');
  YAHOO.util.Dom.addClass('expanded'+id, 'hide');
};

OV.comments.expandMain = function(e) {
  YAHOO.util.Event.preventDefault(e);
  YAHOO.util.Dom.addClass('expandMain', 'hide');
  YAHOO.util.Dom.removeClass('contractMain', 'hide');
  YAHOO.util.Dom.removeClass('expandedMain', 'hide');
};

OV.comments.contractMain = function(e) {
  YAHOO.util.Event.preventDefault(e);
  YAHOO.util.Dom.addClass('contractMain', 'hide');
  YAHOO.util.Dom.removeClass('expandMain', 'hide');
  YAHOO.util.Dom.addClass('expandedMain', 'hide');
};

OV.comments.showForm = function(e, args) {
  if (e) YAHOO.util.Event.preventDefault(e);
  //See if current user is logged in
  if (!OV.comments.loggedIn) {
    window.location = "/session/new";
    return;
  }
  if (OV.comments.commentFormHtml == "") {
    YAHOO.lang.later(1000, this, OV.comments.showForm, [e, args]);
    return;
  }
  var id = args[0];
  var clazz = args[1];
  if (clazz) {
    var formId = "commentForm"+clazz+id;
    var submitId = "submitForm"+clazz+id;
    YAHOO.util.Dom.removeClass('newComment' + clazz + id, 'hide');
    YAHOO.util.Dom.get("commentFormWrapper"+clazz+id).innerHTML = OV.comments.commentFormHtml.replace("commentForm", formId).replace("submitForm", submitId);
  } else {
    var formId = "commentForm"+id;
    var submitId = "submitForm"+id;
    YAHOO.util.Dom.removeClass('reply' + id, 'hide');
    YAHOO.util.Dom.get("reply"+id).innerHTML = OV.comments.commentFormHtml.replace("commentForm", formId).replace("submitForm", submitId);
  }
  var type = YAHOO.util.Selector.query('input[name=type]', formId, true);
  var parent_id = YAHOO.util.Selector.query('input[name=parent_id]', formId, true);
  type.value = (clazz) ? clazz.underscore() : "comment";
  parent_id.value = id;
};

OV.comments.submitForm = function(e, args) {
  var id = args[0];
  if (args[1]) var type = args[1];
  else var type = "";
  YAHOO.util.Event.preventDefault(e);
  YAHOO.util.Connect.setForm(YAHOO.util.Dom.get("commentForm" + type + id));
  var cObj = YAHOO.util.Connect.asyncRequest('POST', '/comments.json?root_comment_depth='+OV.comments.rootCommentDepth, OV.comments.submitFormCallback);
  if (args[1]) {
    var spinnerContainer = YAHOO.util.Dom.get("commentFormSpinner"+args[1]+id);
    var replaceContainer = YAHOO.util.Dom.get("newComment"+args[1]+id);
  } else {
    var spinnerContainer = YAHOO.util.Dom.get("commentFormSpinner"+id);
    var replaceContainer = YAHOO.util.Dom.get("reply"+id);
  }
  if (spinnerContainer.innerHTML == "") spinnerContainer.innerHTML = "<img src='/lib/img/loading.gif' alt='Loading'/>";
  OV.loading.showSpinner(spinnerContainer, replaceContainer);
};

OV.comments.submitFormCallback = {
  success: function(o) {
    var rs = YAHOO.lang.JSON.parse(o.responseText);
    if(rs.errors){
      alert(rs.errors);
      if (rs.type == "")  OV.loading.hideSpinner("commentFormSpinner" + rs.type + rs.parent_id, "reply" + rs.parent_id);
      else OV.loading.hideSpinner("commentFormSpinner" + rs.type + rs.parent_id, "newComment" + rs.type + rs.parent_id);
    } else {
      //Clear the comment form
      OV.comments.clearCommentForm(YAHOO.util.Dom.get("commentForm"+rs.parent_id));
      if (rs.comment_html) {
	//Comment is immediately published
	if (rs.type && rs.type != "") {
	  var list = null;
	  var parent = YAHOO.util.Dom.get("parent" + rs.type + rs.parent_id);
	} else {
	  var list = YAHOO.util.Dom.get("commentChildren" + rs.parent_id);
	  var parent = YAHOO.util.Dom.get("commentNode" + rs.parent_id);
	}
	if (list) {
	  list.innerHTML = list.innerHTML + rs.comment_html;
	} else if (parent) {
	  if (parent.innerHTML.indexOf("Be the first to") >= 0) {
	    parent.innerHTML = rs.comment_html;
	  } else {
	    parent.innerHTML = parent.innerHTML + "<ul>" + rs.comment_html + "</ul>";
	  }
	}
	OV.loading.hideSpinner("commentFormSpinner" + rs.type + rs.parent_id);
      } else {
	OV.loading.hideSpinner("commentFormSpinner" + rs.type + rs.parent_id, "successful_comment" + rs.type + rs.parent_id);
      }
    }
  },
  failure: function(o) {
  }
};

OV.comments.clearCommentForm = function(form) {
  var fields = YAHOO.util.Dom.getElementsBy(OV.comments.isClearableFormElement, null, form);
  for (var i=0; i<fields.length; i++) {
    fields[i].value = null;
  }
};

OV.comments.isClearableFormElement = function(el) {
  return el.id == "comment_title" || el.id == "comment_html";
};

OV.comments.isAbuseReportLink = function(el) {
  return el.id.indexOf("reportAbuse") == 0;
};

OV.comments.isShowFormLink = function(el) {
  return el.id.indexOf("showForm") == 0;
};

OV.comments.isSubmitFormButton = function(el) {
  return el.id.indexOf("submitForm") == 0;
};

OV.comments.isUserVoteLink = function(el) {
  return el.id.indexOf("user_vote_link_") == 0;
};

OV.comments.getIdSuffix = function(el, prefix) {
  return el.id.slice(prefix.length, el.id.length);
};
