var sns = {
	init: function(devId) {
		if (!devId) {
			return false;
		}
		sns.params.devId = devId;
		sns.calls.getToken();
	}
}
sns.params = {
	baseAuthURI: "https://api.screenname.aol.com/",
	baseAjaxURI: "http://www.weblogsinc.com/b-c/directlogin_proxy.php",
	devId: null,
	token: null,
	callbacks: {
		getToken:["sns.callbacks.getToken"],
		getInternalInfo:["sns.callbacks.getInternalInfo"]
	},
	calls: {
		getToken:"auth/getToken",
		getInternalInfo:"auth/getInternalInfo"
	},
	sns_default_form:
			'<label for="sns_screenname">Screenname:<br />'+
			'<input id="sns_screenname" type="text" class="formtext" value="" /></label>'+
			'<label for="sns_password">Password:<br />'+
			'<input id="sns_password" type="password" class="formtext" value="" /></label>'
	,
	sns_loading: '<p align="center"><img src="/media/loading.gif"></p>',
	SAFARI: navigator.userAgent.indexOf("Safari")>-1 && !document.all,
	MOZILLA: navigator.userAgent.indexOf("Firefox")>-1 && !document.all,
	MSIE: document.all && !window.opera,
	OPERA: window.opera,
	this_href: window.location.href.split('#')[0]
}
sns.core = {
	MailData: [],
	requestData: function(transactionObject)
	{
		var len = sns.core.MailData.length;
		transactionObject.timestamp = Date.parse(new Date());
		sns.core.MailData[len] = {};
		sns.core.MailData[len].oScript = document.createElement("script");
		sns.core.MailData[len].oScript.setAttribute("id","MailData-" + len);
		sns.core.MailData[len].oScript.setAttribute("type","text/javascript");
		sns.core.MailData[len].objData = transactionObject;
		if(transactionObject.dataURI.indexOf("?") == -1) {
			transactionObject.dataURI+="?r=" + len + "&nocache=" + Date.parse(new Date());
		} else {
			transactionObject.dataURI+="&r=" + len + "&nocache=" + Date.parse(new Date());
		}
		sns.core.MailData[len].oScript.setAttribute("src",transactionObject.dataURI);
		document.getElementsByTagName("head")[0].appendChild(sns.core.MailData[len].oScript);
	},
	acceptData: function(json)
	{
		var requestId = parseInt(json.response.requestId);
		var code = parseInt(json.response.statusCode);
		var type = sns.core.MailData[requestId].objData.type;
		if(code != 200)
		{
			if(code == 401 && type != "getToken")
			{
				return;
			}
		}
		eval("sns.callbacks." + type + "(json)");
	}
}
sns.calls = {
	getToken: function()
	{
		var tObj = {
			dataURI: sns.params.baseAuthURI + sns.params.calls.getToken + "?k=" + sns.params.devId + "&f=json&c=sns%2Ecore%2EacceptData",
			type:"getToken"
		}
		sns.core.requestData(tObj);
	},
	loggedin: function(state)
	{
		if (state == 1)
		{
			var snsForm =
					'<p>'+
						'<label for="">Name:</label>'+
						'<input id="sns_displayname" readonly type="text" size="20" class="formtext" value="" />'+
					'</p>'+
					'<p>'+
						'<label for="">E-mail:</label>'+
						'<input id="sns_email" readonly type="text" size="20" class="formtext" value=""/>'+
					'</p>';
			//document.getElementById('sns').innerHTML = snsForm;
		}
		else
		{
			var snsForm = sns.params.sns_default_form + '<input id="sns_login_type" type="hidden" value="1" />';
			document.getElementById('sns').innerHTML = snsForm;
		}
	},
	login: function()
	{
		var login_type = document.getElementById('sns_login_type').value;
		switch (login_type)
		{
			case '1':
				var screenname = document.getElementById('sns_screenname').value;
				var password = document.getElementById('sns_password').value;
				document.getElementById('sns').innerHTML = sns.params.sns_loading;
				postURL('/b-c/directlogin_proxy.php','type=login&screenname='+screenname+'&password='+password+ "&referer="+escape(sns.params.this_href));
				break;
			case '2':
				var screenname = document.getElementById('sns_screenname').value;
				var securid = document.getElementById('sns_securid').value;
				var challenge_context = document.getElementById('sns_challenge_context').value;
				document.getElementById('sns').innerHTML = sns.params.sns_loading;
				postURL('/b-c/directlogin_proxy.php','type=sichallenge&screenname='+screenname+'&securid='+securid+'&challenge_context='+challenge_context+ "&referer="+escape(sns.params.this_href));
				break;
			case '3':
				var screenname = document.getElementById('sns_screenname').value;
				var password = document.getElementById('sns_password').value;
				var challenge_context = document.getElementById('sns_challenge_context').value;
				document.getElementById('sns').innerHTML = sns.params.sns_loading;
				postURL('/b-c/directlogin_proxy.php','type=pwdchallenge&screenname='+screenname+'&password='+password+'&challenge_context='+challenge_context+ "&referer="+escape(sns.params.this_href));
				break;
			default:
				alert("invalid login type");
				break;
		}
		
		return false;
	},
	getInternalInfo: function()
	{
		var tObj = {
			dataURI: sns.params.baseAjaxURI + "?call="+escape(sns.params.baseAuthURI + sns.params.calls.getInternalInfo + "?k=" + sns.params.devId + "&f=json&a=" + encodeURIComponent(sns.params.token) + "&referer="+sns.params.this_href+"&attribute=email"),
			 type:"getInternalInfo"
		}
		document.getElementById('sns').innerHTML = '<img src="/media/loading.gif">';
		sns.core.requestData(tObj);
	}

}

sns.callbacks = {
	getToken: function(json)
	{
		if(json.response.statusCode == 200) 
		{
			sns.params.token = json.response.data.token.a;
			sns.calls.getInternalInfo();
			//sns.calls.loggedin(1);
		}
		else
			sns.calls.loggedin(0);
			/*else if (json.response.statusCode == 450 || json.response.statusCode == 401)
			{
				console.log("450/01");
			} else if (json.response.statusCode == 330) {
				console.log("330" +dump(json));
			} else {
				console.log("Error! Status Code = " + json.response.statusCode);
				//document.getElementById("ErrorMessage").style.display = '';
			}*/
	},
	login: function(result,resp)
	{
		if (resp) {
			var response = eval('(' + resp + ')');
		} else {
			var response = '';
		}
		switch (result)
		{
			case 0:
				var snsForm = 'The Screen Name Service is temporarily unavailable. Please use the New Readers or Returning tab to post a comment.';
				document.getElementById('sns').innerHTML = snsForm;
				
				break;
			case 1: //OK
				var snsForm = ''+
						'<label for="">Name:</label>'+
						'<input readonly type="text" class="formtext" value="'+response.name+'" />'+
						'<label for="">E-mail:</label>'+
						'<input readonly type="text" class="formtext" value="'+response.email+'"/>'+
						'<input type="hidden" name="token" id="token" value="'+response.token+'"/>';
				document.getElementById('sns').innerHTML = snsForm;
				if (inputValidation())
					document.commentform.submit();
				
				break;
			case 2: //pw challenge
			case 4: //asqchallenge
				var snsForm = ''+
							sns.params.sns_default_form+
							'<input id="sns_challenge_context" type="hidden" value="'+response.challenge_context+'" />'+
							'<input id="sns_login_type" type="hidden" value="3" />';
				document.getElementById('sns').innerHTML = snsForm;
				document.getElementById('formerrors').innerHTML = "Invalid login information. Please re-enter your Screename and password";
				
				break;
			case 3: //securID challenge
				var snsForm = ''+
					'<p>'+
						'<span style="float:right"><img src="https://sns-static.aolcdn.com/sns/3.6r1/images/49x32_rsa_security.gif"></span>'+
						'<label for="sns_securid">SecurID&copy;:</label>'+
						'<input id="sns_securid" type="text" class="formtext" value="" />'+
					'</p>'+
					'<input id="sns_screenname" type="hidden" value="'+response.screenname+'" />'+
					'<input id="sns_challenge_context" type="hidden" value="'+response.challenge_context+'" />'+
					'<input id="sns_login_type" type="hidden" value="2" />';
				document.getElementById('sns').innerHTML = snsForm;
				document.getElementById('sns_securid').focus();
				document.getElementById('formerrors').innerHTML = "Please enter your SecurID Code";
				
				break;
			case 5: //Missing required parameters
				var snsForm = ''+
							sns.params.sns_default_form+
							'<input id="sns_login_type" type="hidden" value="1" />';
				document.getElementById('sns').innerHTML = snsForm;
				document.getElementById('formerrors').innerHTML = "Invalid login information. Please re-enter your Screename and password";

				break;
		}
	},
	getInternalInfo: function(resp)
	{

		
		if (resp) {
			var response = eval('(' + resp + ')');
		} else {
			var response = '';
		}
		
		if (response.response.statusText != "OK")
		{
			sns.calls.loggedin(0);
			return;
		}
		
		var display_name = response.response.data.userData.displayName;
		var email = response.response.data.userData.attributes.email;
		var snsForm = ''+
				'<label for="">Name:</label>'+
				'<input readonly type="text" class="formtext" value="'+display_name+'" />'+
				'<label for="">E-mail:</label>'+
				'<input readonly type="text" class="formtext" value="'+email+'"/>'+
				'<input type="hidden" name="token" id="token" value="'+sns.params.token+'"/>';
			document.getElementById('sns').innerHTML = snsForm;
			//document.getElementById('snslogin').style.display='none';
	}

	
}
	
function dump(arr,level) 
{
	var dumped_text = '';
	if(!level) level = 0;
	
	//The padding given at the beginning of the line.
	var level_padding = '';
	for(var j=0;j<level+1;j++) level_padding += "    ";
	
	if(typeof(arr) == 'object') { //Array/Hashes/Objects 
		for(var item in arr) {
			var value = arr[item];
			
			if(typeof(value) == 'object') { //If it is an array,
				dumped_text += level_padding + "'" + item + "' ...";
				dumped_text += dump(value,level+1);
			} else {
				dumped_text += level_padding + "'" + item + "' => \"" + value + "\" ";
			}
		}
	} else { //Stings/Chars/Numbers etc.
		dumped_text = "===>"+arr+"<===("+typeof(arr)+")";
	}
	return dumped_text;
}

