
/*Dynamically loads a file of type 'type' (js/css) anytime during program execution.*/
function oneWidgetDynamicLoadFile(url,type) {
	if (type == 'js') {
  		var e = document.createElement("script");
  		e.type = "text/javascript";
  		e.src = url;
	} else if (type == 'css') {
  		var e = document.createElement("link");
  		e.type = "text/css";
  		e.rel = "stylesheet";
  		e.href = url;
	} else { return; }
	
	document.getElementsByTagName("head")[0].appendChild(e);
}

/*Simulate an Ajax request by dynamically loading a javascript file*/
function oneWidgetAjax(url, el) {
	// See if there is a custom element to insert the "loading" indicator
	var container = 'oneWidgetAllMainContainer';
	if (typeof el != 'undefined') {
		container = el;
		
		// Append the div id to query string, so we know where to insert new output
		url = url + '&ow_ajax_div=' + el;
	}
	
	// Check for wurl
	if (url.search('&wurl=') < 0) {
		url += '&wurl=' + escape(window.location.href);
	}
	
	// Check for ow_ajax
	if (url.search('&ow_ajax=') < 0) {
		url += '&ow_ajax=true';
	}
	
	// Check for wsetup
	if (url.search('&wsetup=') < 0) {
		url += '&wsetup=true';
	}
	
	// Append timestamp onto ajax request
	url = url + '&wms=' + new Date().getTime();
	
	oneWidgetShowLoading(container);
	oneWidgetDynamicLoadFile(url, 'js');
}

/*Simulate an Ajax request and generate the url with the given parameters*/
function oneWAjax(widget, action, el, show_loading, remove, add) {
	var url_str = "var params = oneWidget_" + widget;
	eval(url_str);
	
	// Validate
	if (!params || typeof params == 'undefined' || params == null) {
		return;
	}
	
	// Begin url
	var url = params.widgetURL + '/' + params.method + '/' + params.widget + '/' + action + '?wsetup=true&ow_ajax=true';
	url += '&wurl=' + escape(window.location.href);;
	
	// See if there is a custom element to insert the "loading" indicator
	var valid_el = false;
	if (typeof el != 'undefined' && el) {
		valid_el = true;
		// Append the div id to query string, so we know where to insert new output
		url = url + '&ow_ajax_div=' + escape(el);
	}
	
	// Get remove lists
	var remove_array = new Array();
	if (typeof remove != "undefined" && remove.length > 0) {
		var remove_array = remove.split(',');
	}
	
	// Add all original params
	for (var name in params.params) {
		// Only if this name is not in the remove list
		if (!oneWidgetInArray(name, remove_array)) {
			url += '&' + name + '=' + escape(params.params[name]);
		}
	}
	
	// Add all custom params
	if (typeof add != "undefined" && add.length > 0) {
		// Do we start with &?
		if (add.charAt(0) != '&') {
			url += '&';
		}
		
		// Add all custom params
		url += add;
	}
	
	// Append timestamp onto ajax request
	url = url + '&wms=' + new Date().getTime();
	
	// Do we want to show loading?
	if (valid_el && typeof show_loading != 'undefined' && show_loading) {
		oneWidgetShowLoading(el);
	}
	
	// Load ajax file
	oneWidgetDynamicLoadFile(url, 'js');
}

/*Show a loading indicator image while making an ajax request*/
function oneWidgetShowLoading(el) {
	var elm = document.getElementById(el);
	
	// Verify
	if (typeof elm == 'undefined') {
		return;
	}
	
	// Get left margin to center
	var left_margin = (elm.offsetWidth - 12) / 2;
	
	// Place the loading image in container
	var newhtml = '<img src="' + oneWidget_preloadImage.src + '" '
	                 + 'class="oneWidgetLoadingIndicator" '
	                 + 'style="margin-left:' + left_margin + 'px;position:absolute;top:1px;" '
	                 + 'alt="Loading..." />';
	
	//elm.innerHTML = newhtml;
	elm.innerHTML = newhtml + elm.innerHTML;
}

/*Checks if a value exists in an array*/
function oneWidgetInArray(needle, haystack) {
	for ( var x = 0 ; x < haystack.length ; x++ ) {
		if ( haystack[x] == needle ) {
			return true;
		}
	}
	return false;
};
