<!--
// -----------------------
// FUNCTION: fGenerateHaveYourSayLink
// DESCRIPTION: A function that generates the mark up for a "Have your say" link.
// ARGUMENTS: sElemendId, sCommentFormElementId, sLinkText
// RETURN: None
// -----------------------
function fGenerateHaveYourSayLink(sElemendId, sCommentFormElementId, sLinkText) {
	var eLink = document.getElementById(sElemendId);
	var sHTML = '<ul><li class="have-your-say"><a class="link-666" href="#comments-form" onclick="javascript:return ! fShowHideCommentForm(\'' + sCommentFormElementId + '\');" onkeypress="javascript:return ! fShowHideCommentForm(\'' + sCommentFormElementId + '\');">' + sLinkText + '</a></li></ul>';
	if (sLinkText == 'Hide the form') {
		sHTML = '<ul><li class="hide-the-form"><a class="link-666" href="#comments-form" onclick="javascript:return ! fShowHideCommentForm(\'' + sCommentFormElementId + '\');" onkeypress="javascript:return ! fShowHideCommentForm(\'' + sCommentFormElementId + '\');">' + sLinkText + '</a></li></ul>';
	}
	eLink.innerHTML = sHTML;
}
// -----------------------
// FUNCTION: fGenerateHaveYourSayNoLink
// DESCRIPTION: A function that generates the mark up for a "Have your say" link  when no comments have been posted.
// ARGUMENTS: sElemendId, sCommentFormElementId, sLinkText
// RETURN: None
// -----------------------
function fGenerateHaveYourSayNoLink(sElemendId, sCommentFormElementId, sLinkText) {
	var eLink = document.getElementById(sElemendId);
	var sHTML = '<ul><li class="have-your-say"><a class="link-666" href="#comments-form" onclick="javascript:return ! fShowHideCommentFormNoLinks(\'' + sCommentFormElementId + '\');" onkeypress="javascript:return ! fShowHideCommentFormNoLinks(\'' + sCommentFormElementId + '\');">' + sLinkText + '</a></li></ul>';
	if (sLinkText == 'Hide the form') {
		sHTML = '<ul><li class="hide-the-form"><a class="link-666" href="#comments-form" onclick="javascript:return ! fShowHideCommentFormNoLinks(\'' + sCommentFormElementId + '\');" onkeypress="javascript:return ! fShowHideCommentFormNoLinks(\'' + sCommentFormElementId + '\');">' + sLinkText + '</a></li></ul>';
	}
	eLink.innerHTML = sHTML;
}
// -----------------------
// FUNCTION: fShowHideCommentForm
// DESCRIPTION: A function that shows or hides the comment form.
// ARGUMENTS: sElemendId
// RETURN: True
// -----------------------
function fShowHideCommentForm(sElemendId) {
	var eElement = document.getElementById(sElemendId);
	var sClassName = eElement.className;
	var sLinkText = '';
	if (sClassName.match(' access-text') || sClassName.match('access-text')) {
		sLinkText = sCollapseForm;
	} else {	
		sLinkText = sHaveYourSay;
	}
	fGenerateHaveYourSayLink('have-your-say-link-1', sElemendId, sLinkText);
	fGenerateHaveYourSayLink('have-your-say-link-2', sElemendId, sLinkText);
	// Show or hide the form
	fShowHideElement(sElemendId);	
	return true;
}
// -----------------------
// FUNCTION: fShowHideCommentFormNoLinks
// DESCRIPTION: A function that shows or hides the comment form when no comments have been posted..
// ARGUMENTS: sElemendId
// RETURN: True
// -----------------------
function fShowHideCommentFormNoLinks(sElemendId) {
	var eElement = document.getElementById(sElemendId);
	var sClassName = eElement.className;
	var sLinkText = '';
	if (sClassName.match(' access-text') || sClassName.match('access-text')) {
		sLinkText = sCollapseForm;
	} else {	
		sLinkText = sHaveYourSay;
	}
	fGenerateHaveYourSayNoLink('have-your-say-link-2', sElemendId, sLinkText);
	// Show or hide the form
	fShowHideElement(sElemendId);	
	return true;
}
// -----------------------
// FUNCTION: fGenerateReadAllCommentsLink
// DESCRIPTION: A function that generates the mark up for a "Show all comments" link.
// ARGUMENTS: sElemendId, sCommentFormElementId, sLinkText
// RETURN: None
// -----------------------
function fGenerateReadAllCommentsLink(sElemendId, sCommentFormElementId, sLinkText) {
	var sHTML = '';
	var eLink = document.getElementById(sElemendId);
	//sHTML += '<div class="puff-top">';
	sHTML += '<div>';
	sHTML += '<div class="clear"></div>';
	sHTML += '</div>';
	sHTML += '<div class="padding-bottom-5"></div>';
	sHTML += '<div class="float-left">';
	sHTML += '<ul id="read-all-comments" class="chevron-list chevron-blue">';
	sHTML += '<li><a class="link-666" href="#" onclick="javascript:return ! fShowHideAllComments(\'' + sElemendId + '\');" onkeypress="javascript:return ! fShowHideAllComments(\'' + sElemendId + '\');">' + sLinkText + '</a></li>';
	sHTML += '</ul>';
	sHTML += '</div>';
	sHTML += '<div class="float-right">';
	sHTML += '<ul id="have-your-say-link-2">';
	sHTML += '</ul>';
	sHTML += '</div>';
	sHTML += '<div class="clear"></div>';
	eLink.innerHTML = sHTML;

	var eElement = document.getElementById(sCommentFormElementId);
	var sClassName = eElement.className;
	var sLinkText = '';
	if (sClassName.match(' access-text') || sClassName.match('access-text')) {
		sLinkText = sHaveYourSay;
	} else {	
		sLinkText = sCollapseForm;
	}	
	fGenerateHaveYourSayLink('have-your-say-link-2', sCommentFormElementId, sLinkText);
}
// -----------------------
// FUNCTION: fGenerateReadNoCommentsLink
// DESCRIPTION: A function that generates the mark up when no comments have been posted.
// ARGUMENTS: sElemendId, sCommentFormElementId, sLinkText
// RETURN: None
// -----------------------
function fGenerateNoCommentsLink(sElemendId, sCommentFormElementId, sLinkText) {
	var sHTML = '';
	var eLink = document.getElementById(sElemendId);
	//sHTML += '<div class="puff-top">';
	sHTML += '<div>';
	sHTML += '<div class="clear"></div>';
	sHTML += '</div>';
	sHTML += '<div class="padding-bottom-5"></div>';
	sHTML += '<div class="float-left">';
	sHTML += '<ul id="read-all-comments" class="chevron-list chevron-blue">';
	sHTML += '<li><a class="link-666" href="#" onclick="javascript:return ! fShowHideCommentFormNoLinks(\'' + sElemendId + '\');" onkeypress="javascript:return ! fShowHideCommentFormNoLinks(\'' + sElemendId + '\');">' + sLinkText + '</a></li>';
	sHTML += '</ul>';
	sHTML += '</div>';
	sHTML += '<div class="float-right">';
	sHTML += '<ul id="have-your-say-link-2">';
	sHTML += '</ul>';
	sHTML += '</div>';
	sHTML += '<div class="clear"></div>';
	eLink.innerHTML = sHTML;

	var eElement = document.getElementById(sCommentFormElementId);
	var sClassName = eElement.className;
	var sLinkText = '';
	if (sClassName.match(' access-text') || sClassName.match('access-text')) {
		sLinkText = sHaveYourSay;
	} else {	
		sLinkText = sCollapseForm;
	}	
	fGenerateHaveYourSayNoLink('have-your-say-link-2', sCommentFormElementId, sLinkText);
}
// -----------------------
// FUNCTION: fShowHideAllComments
// DESCRIPTION: A function that shows or hides all/most of the comments.
// ARGUMENTS: sElemendId
// RETURN: True
// -----------------------
function fShowHideAllComments(sElemendId) {

	var eElement = document.getElementById('comments-4-to-n');
	var sClassName = eElement.className;
	var sLinkText = '';
	if (sClassName.match(' access-text') || sClassName.match('access-text')) {
		sLinkText = sHideMostComments;
	} else {	
		sLinkText = sReadAllComments;
	}
	fGenerateReadAllCommentsLink(sElemendId, 'comments-form', sLinkText);
	// Show or hide the comments
	fShowHideElement('comments-4-to-n');
	return true;
}
//-->