// bookmark v1 2007-08-15 14:33:00
BookMark = function(o){
	this._site = o.site;
	this._storyid = o.storyid;
	this._sectionid = o.sectionid;
	this._url = o.url;
	this._edition = o.edition;
	this._headline;
	if(newsi.hasDOM()){
		this._init();
	}
};

BookMark.prototype._init = function(){
	var metaTags = document.getElementsByTagName("meta");
	for (var i = 0; i < metaTags.length; i++) {
	    var tag = metaTags[i];
	    var tagType = metaTags[i].getAttribute("name");
	    if (tagType == "Headline"){
		this._headline = metaTags[i].getAttribute("content");
	    }
	}	
	this._registerEvents();
};

BookMark.prototype._registerEvents = function(){
	this.d = new newsi.HTML.DOM();
	var elts = ['digg', 'delicious', 'facebook', 'reddit', 'stumbleupon'];	
	for(var e in elts){
		this["ev"+e]=new newsi.Event();
		this["ev"+e].addListener("onclick",elts[e],this,"_clickHandler",false,elts[e]);
	};
};

BookMark.prototype._clickHandler = function(e){
	this._hitLiveStats(e);
	this._popUpWindow(e);
};

BookMark.prototype._hitLiveStats = function(e){
	var service = e[0];
	liveStatsSSB(this._site,this._storyid,this._sectionid,service,this._url,this._edition);
	
};

BookMark.prototype._popUpWindow = function(e){
	var service = e[0];	
	var fullStoryUrl = "http://news.bbc.co.uk" + this._url;
	var servUrl;
	var o = new Object();
	switch(true){
		case service == "delicious":
		servUrl = "http://del.icio.us/post?v=4&noui&jump=close&url=" + fullStoryUrl + "&title=" + this._headline;
		break;
		
		case service == "digg":
		servUrl = "http://digg.com/remote-submit?phase=2&url=" + fullStoryUrl + "&title=" + this._headline;
		break;		
		
		case service == "reddit":
		servUrl = "http://reddit.com/submit?url=" + fullStoryUrl + "&title=" + this._headline;
		break;
		
		case service == "facebook":
		servUrl = "http://www.facebook.com/sharer.php?u=" + fullStoryUrl + "&t=" + this._headline;
		break;
		
		case service == "stumbleupon":
		servUrl = "http://www.stumbleupon.com/submit?url=" + fullStoryUrl + "&title=" + this._headline;
		break;
		
		default:
		break;
		
	};
	o.url = servUrl;
	o.resizable = 1;
	o.scrollbars = 1;
	o.width = 700;
	var win = new newsi.Window();
	win.popup(o);

};


